/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.managed.BaseTaskKeys;
import com.ibm.hwmca.base.saverest.ConfigDataRepConstants;
import com.ibm.hwmca.base.saverest.CustDataRepWarningBean;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.saverest.SaveRestoreErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;

public class CustDataRepWarningTasklet
extends PanelTasklet
implements ConfigDataRepConstants,
SaveRestoreErrorIds {
    private static final String TRACE_MASKT = "XCDRTSKT";
    private static final String TRACE_MASKF = "XCDRTSKF";
    private static final String TRACE_MASKD = "XCDRTSKD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(37, "ConfigDataRepWarning");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.saverest.res.CustDataRepWarning";
    private static final String CUST_DATA_REP_WARNING_PANEL_NAME = "CustDataRepWarningPanel";
    private CustDataRepWarningBean custDataRepWarningBean = new CustDataRepWarningBean();
    private DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static BaseMessageTitle title = new BaseMessageTitle("DATAREP6.TITLE");
    private static BaseMessageText text;
    private String dataSourceKey;
    private User user;

    public CustDataRepWarningTasklet() {
        Trace.trace(TRACE_MASKT, "<> CustDataRepWarningTasklet.CustDataRepWarningTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> CustDataRepWarningTasklet.service(" + request + ", " + response + ")");
        if (request.isInitialRequest()) {
            this.dataSourceKey = (String)request.getData("Async_Task_Object_Key");
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            ObjectId id = BaseTaskKeys.getObjectIdFromKey("com.ibm.hwmca.base.saverest.ConfigDataRepTasklet");
            UserContext userContext = UserContext.getCurrentUserContext();
            this.user = User.getUser(userContext.getUserid());
            this.custDataRepWarningBean.setBeanName("CustDataRepWarningBean");
            this.custDataRepWarningBean.setDataTypeOutput("- " + this.dataRepApp.getCustomDataName(this.dataSourceKey));
            this.custDataRepWarningBean.setDisplayUnconfigure(this.user.isObjectPermitted(id));
            response.replace(AUIML_FILE_NAME, CUST_DATA_REP_WARNING_PANEL_NAME, this.custDataRepWarningBean);
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("Event");
            if (event.getElementName().endsWith("OkButton")) {
                String[] actionsRBG = (String[])request.getData("ActionsRBG");
                String[] substData = new String[]{this.dataRepApp.getCustomDataName(this.dataSourceKey), this.user.getUserName()};
                FrameworkEventText fet = null;
                if (actionsRBG[0].equals("RequestItem")) {
                    this.dataRepApp.setCustomDataLevel(this.dataSourceKey, -1L);
                    fet = new FrameworkEventText(1200, substData);
                    text = new BaseMessageText("DATAREP6");
                } else if (actionsRBG[0].equals("UnconfigureItem")) {
                    this.dataRepApp.removeCustomDataConfigured(this.dataSourceKey);
                    fet = new FrameworkEventText(1201, substData);
                    text = new BaseMessageText("DATAREP7");
                } else {
                    fet = new FrameworkEventText(1202, substData);
                    text = new BaseMessageText("DATAREP8");
                }
                new SystemEventLog(fet, "CustDataLan").log();
                this.showMessageBox(true, title, text, null, null);
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- CustDataRepWarningTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> CustDataRepWarningTasklet.logException(" + throwable + ")");
        new FrameworkLog(_logInfo, 9, throwable).log();
        Trace.trace(TRACE_MASKT, "<- CustDataRepWarningTasklet.logException()");
    }
}

